/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.source;

import lombok.Data;

/**
 * Specifies that the engine data originated from a third-party device for an obsolete GUID.
 */
@Data
public final class SourceThirdPartyObsolete extends Source {

  private static class InstanceHolder {

    private static final SourceThirdPartyObsolete INSTANCE = new SourceThirdPartyObsolete();
  }

  public static final String SOURCE_THIRD_PARTY_OBSOLETE_ID = "SourceThirdPartyObsoleteId";

  private SourceThirdPartyObsolete() {
    super(SOURCE_THIRD_PARTY_OBSOLETE_ID, "**ThirdParty Obsolete");
  }

  public static SourceThirdPartyObsolete getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
