/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.statusdata;

import com.geotab.model.entity.EntityWithVersion;
import com.geotab.model.entity.controller.Controller;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.diagnostic.Diagnostic;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * A record that represents an engine status record from the engine system of the specific {@link Device}.
 */
@Data
@NoArgsConstructor
@SuperBuilder(builderMethodName = "statusDataBuilder")
public class StatusData extends EntityWithVersion {

  /**
   * The recorded value of the diagnostic parameter.
   */
  private Double data;

  /**
   * The date and time of the logged event.
   */
  private LocalDateTime dateTime;

  /**
   * Sets the StatusData for the {@link Device} specified.
   */
  private Device device;

  /**
   * The {@link Diagnostic} for the {@link Device} specified.
   */
  private Diagnostic diagnostic;

  /**
   * The {@link Controller} for the {@link Device} specified.
   */
  private Controller controller;

  /**
   * The MAC address of the sensor.
   */
  private Long address;
}
