/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.geotab.model.entity.device.GoDevice;
import com.geotab.model.entity.user.Driver;
import com.geotab.model.entity.user.Key;
import lombok.Builder;
import lombok.Data;

/**
 * Message content to control a{@link GoDevice}'s {@link Driver} white list.
 */
@Data
public class DriverWhiteListContent extends DataToComponentContent {

  /**
   * Key can be derived from a driver's "keys" property.
   */
  private Key driverKey;

  /**
   * The value indicating whether to add to or remove from the white list. If [true] "ClearWhiteList" will be set to
   * [false] and the driver will be added to the white list. If [false] the driver will be removed from the white list.
   */
  @JsonProperty("addToWhiteList")
  private boolean addToWhiteList;

  /**
   * The value indicating whether to clear the white list. If [true] "AddToWhiteList" will be set to [false] and
   * "DriverKey" will be set to [null].
   */
  @JsonProperty("clearWhiteList")
  private boolean clearWhiteList;

  @Builder(builderMethodName = "driverWhiteListContentBuilder")
  public DriverWhiteListContent(Key driverKey, boolean addToWhiteList, boolean clearWhiteList) {
    super(MessageContentType.DRIVER_WHITE_LIST, 0, 7, 0, false);
    this.driverKey = driverKey;
    this.addToWhiteList = addToWhiteList;
    this.clearWhiteList = clearWhiteList;
  }

  public DriverWhiteListContent() {
    super(MessageContentType.DRIVER_WHITE_LIST, 0, 7, 0, false);
  }
}
