/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The contents of a {@link TextMessage} that will be delivered to a GoTalk.
 */
@Data
@NoArgsConstructor
public class GoTalkContent extends TextMessageContentType {

  private String message;

  @Builder(builderMethodName = "goTalkContentBuilder")
  public GoTalkContent(String message) {
    super(MessageContentType.GO_TALK);
    this.message = message;
  }
}
