/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import com.geotab.model.Id;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Message content that can send a GPS location to a device. Derived from {@link TextMessage}
 *
 * <p>To reset the location on a device, a location message with latitude/longitude 0 can be sent
 * to the device.
 */
@Data
@NoArgsConstructor
public class LocationContent extends TextContent {

  private Integer id;
  /**
   * The address of the stop.
   */
  private String address;

  /**
   * The latitude of the stop.
   */
  private double latitude;

  /**
   * The longitude of the stop.
   */
  private double longitude;

  /**
   * The Id of the route message.
   */
  private Id routeId;

  @Builder(builderMethodName = "locationContentBuilder")
  public LocationContent(Integer id, String message, Boolean urgent, String address,
      double latitude, double longitude, Id routeId) {
    super(MessageContentType.LOCATION, message, urgent);
    this.id = id;
    this.address = address;
    this.latitude = latitude;
    this.longitude = longitude;
    this.routeId = routeId;
  }
}
