/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.serialization.ByteArrayDeserializer;
import com.geotab.model.serialization.ByteArraySerializer;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The contents of a {@link TextMessage} containing data to give to a third-party IOX Add-On over an RS232.
 */
@Data
@NoArgsConstructor
public class SerialIoxContent extends DataToComponentContent {

  /**
   * The data to send to the IoxAddon. Up to 249 bytes can be sent.
   */
  @JsonDeserialize(using = ByteArrayDeserializer.class)
  @JsonSerialize(using = ByteArraySerializer.class)
  private Byte[] data;


  /**
   * The channel the IoxAddOn is communicating over. 0 means the Add-On is not attached.
   */
  private int channel;

  public void setChannel(int channel) {
    this.channel = channel;
    this.setDeviceIndex(channel);
  }

  @Builder(builderMethodName = "serialIoxContentBuilder")
  public SerialIoxContent(Byte[] data, int channel) {
    super(MessageContentType.SERIAL_IOX, 0, 0, channel, true);
    this.data = data;
    this.channel = channel;
  }
}
