/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The contents of a GPS Text Message. See also:
 *
 * <ul>
 *   <li>
 *     {@link CannedResponseContent}
 *   </li>
 *   <li>
 *     {@link LocationContent}
 *   </li>
 * </ul>
 */
@Data
@NoArgsConstructor
public class TextContent extends TextMessageContentType {

  private String message;
  private Boolean urgent;

  @Builder
  public TextContent(String message, Boolean urgent) {
    super(MessageContentType.NORMAL);
    this.message = message;
    this.urgent = urgent;
  }

  @Builder(builderMethodName = "textContentBuilder")
  public TextContent(MessageContentType messageContentType, String message, Boolean urgent) {
    super(messageContentType);
    this.message = message;
    this.urgent = urgent;
  }
}
