/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.textmessage;

import static com.fasterxml.jackson.annotation.JsonTypeInfo.As.EXISTING_PROPERTY;
import static com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME;
import static com.geotab.model.entity.group.RootGroup.ROOT_GROUP_ID;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.geotab.model.entity.group.RootGroup;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The type of the text message content.
 */
@Data
@NoArgsConstructor()
@JsonTypeInfo(use = NAME, include = EXISTING_PROPERTY, property = "contentType", visible = true,
    defaultImpl = TextContent.class)
@JsonSubTypes({
    @Type(value = RootGroup.class, name = ROOT_GROUP_ID),
    @Type(value = CannedResponseContent.class, name = TextMessageContentType.CANNED_RESPONSE),
    @Type(value = DriverWhiteListContent.class, name = TextMessageContentType.DRIVER_WHITE_LIST),
    @Type(value = GoTalkContent.class, name = TextMessageContentType.GO_TALK),
    @Type(value = IoxOutputContent.class, name = TextMessageContentType.IOX_OUTPUT),
    @Type(value = LocationContent.class, name = TextMessageContentType.LOCATION),
    @Type(value = MimeContent.class, name = TextMessageContentType.MIME_CONTENT),
    @Type(value = PassthroughEnabledMessage.class, name = TextMessageContentType.PASSTHROUGH_ENABLED_MESSAGE),
    @Type(value = SerialIoxContent.class, name = TextMessageContentType.SERIAL_IOX),
    @Type(value = StatusDataRequestContent.class, name = TextMessageContentType.STATUS_DATA_REQUEST)
})
public abstract class TextMessageContentType {

  public static final String NORMAL = "Normal";
  public static final String CANNED_RESPONSE = "CannedResponse";
  public static final String LOCATION = "Location";
  public static final String DATA_TO_COMPONENT = "DataToComponent";
  public static final String STATUS_DATA_REQUEST = "StatusDataRequest";
  public static final String IMMOBILIZATION = "Immobilization";
  public static final String GO_TALK = "GoTalk";
  public static final String IOX_OUTPUT = "IoxOutput";
  public static final String BEEP = "Beep";
  public static final String SERIAL_IOX = "SerialIox";
  public static final String DRIVER_WHITE_LIST = "DriverWhiteList";
  public static final String MIME_CONTENT = "MimeContent";
  public static final String CAN = "CAN";
  public static final String PASSTHROUGH_ENABLED_MESSAGE = "PassthroughEnabledMessage";
  public static final String VEHICLE_COMMAND = "VehicleCommand";
  public static final String OTAU_CONTENT = "OtauContent";
  public static final String WORKSHOP_MODE = "WorkshopMode";
  public static final String FLASH_MEMORY = "FlashMemory";
  public static final String MIME_REFERENCE_CONTENT = "MimeReferenceContent";

  /**
   * The type of message.
   */
  protected MessageContentType contentType;

  public TextMessageContentType(MessageContentType contentType) {
    this.contentType = contentType;
  }
}
