/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureAmps.UNIT_OF_MEASURE_AMPS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureBytes.UNIT_OF_MEASURE_BYTES_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureCubicMeters.UNIT_OF_MEASURE_CUBIC_METERS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureCubicMetersPerSecond.UNIT_OF_MEASURE_CUBIC_METERS_PER_SECOND_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureDegreesCelsius.UNIT_OF_MEASURE_DEGREES_CELSIUS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureGrams.UNIT_OF_MEASURE_GRAMS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureGramsPerSecond.UNIT_OF_MEASURE_GRAMS_PER_SECOND_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureGramsPerSquareMeter.UNIT_OF_MEASURE_GRAMS_PER_SQUARE_METER_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureHertz.UNIT_OF_MEASURE_HERTZ_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureKiloWattHours.UNIT_OF_MEASURE_KILO_WATT_HOURS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureKilogramsPerKilometer.UNIT_OF_MEASURE_KILOGRAMS_PER_KILOMETER_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureKilometersPerHour.UNIT_OF_MEASURE_KILOMETERS_PER_HOUR_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureKilometersPerKiloWattHour.UNIT_OF_MEASURE_KILOMETERS_PER_KILO_WATT_HOUR_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureKilometersPerKilogram.UNIT_OF_MEASURE_KILOMETERS_PER_KILOGRAM_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureKilometersPerLiter.UNIT_OF_MEASURE_KILOMETERS_PER_LITER_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureLiters.UNIT_OF_MEASURE_LITERS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureLitersPerLaneKilometer.UNIT_OF_MEASURE_LITERS_PER_LANE_KILOMETER_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureLitersPerTonne.UNIT_OF_MEASURE_LITERS_PER_TONNE_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureMeters.UNIT_OF_MEASURE_METERS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureMetersPerSecondSquared.UNIT_OF_MEASURE_METERS_PER_SECOND_SQUARED_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureNewtonMeters.UNIT_OF_MEASURE_NEWTON_METERS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureNewtons.UNIT_OF_MEASURE_NEWTONS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureNone.UNIT_OF_MEASURE_NONE_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureOhms.UNIT_OF_MEASURE_OHMS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureOhmsPerSecond.UNIT_OF_MEASURE_OHMS_PER_SECOND_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasurePartsPerMillion.UNIT_OF_MEASURE_PARTS_PER_MILLION_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasurePascals.UNIT_OF_MEASURE_PASCALS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasurePercentage.UNIT_OF_MEASURE_PERCENTAGE_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasurePulsesPerMeter.UNIT_OF_MEASURE_PULSES_PER_METER_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureRadians.UNIT_OF_MEASURE_RADIANS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureRevolutions.UNIT_OF_MEASURE_REVOLUTIONS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureRevolutionsPerMinute.UNIT_OF_MEASURE_REVOLUTIONS_PER_MINUTE_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureSeconds.UNIT_OF_MEASURE_SECONDS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureVolts.UNIT_OF_MEASURE_VOLTS_ID;
import static com.geotab.model.entity.unitofmeasure.UnitOfMeasureWatts.UNIT_OF_MEASURE_WATTS_ID;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.geotab.model.Id;
import com.geotab.model.entity.NameEntity;
import com.geotab.model.serialization.UnitOfMeasureSerializer;
import com.geotab.util.Util;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Describes the unit of measure (UOM) for engine data logs. In the case where no unit of measure is available; this is
 * represented by "UnitOfMeasureNoneId".
 */
@Data
@NoArgsConstructor
@JsonSerialize(using = UnitOfMeasureSerializer.class)
public class UnitOfMeasure extends NameEntity {

  public UnitOfMeasure(String id) {
    setId(new Id(id));
    setName(id);
  }

  public static UnitOfMeasure fromSystem(String id) {
    if (Util.isEmpty(id)) return null;//@formatter:off
    if (UNIT_OF_MEASURE_AMPS_ID.equals(id)) return UnitOfMeasureAmps.getInstance();
    if (UNIT_OF_MEASURE_BYTES_ID.equals(id)) return UnitOfMeasureBytes.getInstance();
    if (UNIT_OF_MEASURE_CUBIC_METERS_ID.equals(id)) return UnitOfMeasureCubicMeters.getInstance();
    if (UNIT_OF_MEASURE_CUBIC_METERS_PER_SECOND_ID.equals(id)) return UnitOfMeasureCubicMetersPerSecond.getInstance();
    if (UNIT_OF_MEASURE_DEGREES_CELSIUS_ID.equals(id)) return UnitOfMeasureDegreesCelsius.getInstance();
    if (UNIT_OF_MEASURE_GRAMS_ID.equals(id)) return UnitOfMeasureGrams.getInstance();
    if (UNIT_OF_MEASURE_GRAMS_PER_SECOND_ID.equals(id)) return UnitOfMeasureGramsPerSecond.getInstance();
    if (UNIT_OF_MEASURE_GRAMS_PER_SQUARE_METER_ID.equals(id)) return UnitOfMeasureGramsPerSquareMeter.getInstance();
    if (UNIT_OF_MEASURE_HERTZ_ID.equals(id)) return UnitOfMeasureHertz.getInstance();
    if (UNIT_OF_MEASURE_KILOGRAMS_PER_KILOMETER_ID.equals(id)) return UnitOfMeasureKilogramsPerKilometer.getInstance();
    if (UNIT_OF_MEASURE_KILOMETERS_PER_HOUR_ID.equals(id)) return UnitOfMeasureKilometersPerHour.getInstance();
    if (UNIT_OF_MEASURE_KILOMETERS_PER_KILOGRAM_ID.equals(id)) return UnitOfMeasureKilometersPerKilogram.getInstance();
    if (UNIT_OF_MEASURE_KILOMETERS_PER_LITER_ID.equals(id)) return UnitOfMeasureKilometersPerLiter.getInstance();
    if (UNIT_OF_MEASURE_KILO_WATT_HOURS_ID.equals(id)) return UnitOfMeasureKiloWattHours.getInstance();
    if (UNIT_OF_MEASURE_LITERS_ID.equals(id)) return UnitOfMeasureLiters.getInstance();
    if (UNIT_OF_MEASURE_LITERS_PER_LANE_KILOMETER_ID.equals(id)) return UnitOfMeasureLitersPerLaneKilometer.getInstance();
    if (UNIT_OF_MEASURE_LITERS_PER_TONNE_ID.equals(id)) return UnitOfMeasureLitersPerTonne.getInstance();
    if (UNIT_OF_MEASURE_METERS_ID.equals(id)) return UnitOfMeasureMeters.getInstance();
    if (UNIT_OF_MEASURE_METERS_PER_SECOND_SQUARED_ID.equals(id)) return UnitOfMeasureMetersPerSecondSquared.getInstance();
    if (UNIT_OF_MEASURE_NEWTON_METERS_ID.equals(id)) return UnitOfMeasureNewtonMeters.getInstance();
    if (UNIT_OF_MEASURE_NEWTONS_ID.equals(id)) return UnitOfMeasureNewtons.getInstance();
    if (UNIT_OF_MEASURE_NONE_ID.equals(id)) return UnitOfMeasureNone.getInstance();
    if (UNIT_OF_MEASURE_OHMS_ID.equals(id)) return UnitOfMeasureOhms.getInstance();
    if (UNIT_OF_MEASURE_OHMS_PER_SECOND_ID.equals(id)) return UnitOfMeasureOhmsPerSecond.getInstance();
    if (UNIT_OF_MEASURE_PARTS_PER_MILLION_ID.equals(id)) return UnitOfMeasurePartsPerMillion.getInstance();
    if (UNIT_OF_MEASURE_PASCALS_ID.equals(id)) return UnitOfMeasurePascals.getInstance();
    if (UNIT_OF_MEASURE_PERCENTAGE_ID.equals(id)) return UnitOfMeasurePercentage.getInstance();
    if (UNIT_OF_MEASURE_PULSES_PER_METER_ID.equals(id)) return UnitOfMeasurePulsesPerMeter.getInstance();
    if (UNIT_OF_MEASURE_RADIANS_ID.equals(id)) return UnitOfMeasureRadians.getInstance();
    if (UNIT_OF_MEASURE_REVOLUTIONS_ID.equals(id)) return UnitOfMeasureRevolutions.getInstance();
    if (UNIT_OF_MEASURE_REVOLUTIONS_PER_MINUTE_ID.equals(id)) return UnitOfMeasureRevolutionsPerMinute.getInstance();
    if (UNIT_OF_MEASURE_SECONDS_ID.equals(id)) return UnitOfMeasureSeconds.getInstance();
    if (UNIT_OF_MEASURE_VOLTS_ID.equals(id)) return UnitOfMeasureVolts.getInstance();
    if (UNIT_OF_MEASURE_WATTS_ID.equals(id)) return UnitOfMeasureWatts.getInstance();
    if (UNIT_OF_MEASURE_KILOMETERS_PER_KILO_WATT_HOUR_ID.equals(id)) return UnitOfMeasureKilometersPerKiloWattHour.getInstance();
    return new UnitOfMeasure(id);//@formatter:on
  }
}
