/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for mass per second.
 */
@Data
public final class UnitOfMeasureGramsPerSecond extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureGramsPerSecond INSTANCE = new UnitOfMeasureGramsPerSecond();
  }

  public static final String UNIT_OF_MEASURE_GRAMS_PER_SECOND_ID = "UnitOfMeasureGramsPerSecondId";
  public static final String UNIT_OF_MEASURE_GRAMS_PER_SECOND_NAME = "g/s";

  private UnitOfMeasureGramsPerSecond() {
    super(UNIT_OF_MEASURE_GRAMS_PER_SECOND_ID, UNIT_OF_MEASURE_GRAMS_PER_SECOND_NAME);
  }

  public static UnitOfMeasureGramsPerSecond getInstance() {
    return UnitOfMeasureGramsPerSecond.InstanceHolder.INSTANCE;
  }
}
