/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for mass over area.
 */
@Data
public final class UnitOfMeasureGramsPerSquareMeter extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureGramsPerSquareMeter INSTANCE = new UnitOfMeasureGramsPerSquareMeter();
  }

  public static final String UNIT_OF_MEASURE_GRAMS_PER_SQUARE_METER_ID = "UnitOfMeasureGramsPerSquareMeterId";
  public static final String UNIT_OF_MEASURE_GRAMS_PER_SQUARE_METER_NAME = "g/m^2";

  private UnitOfMeasureGramsPerSquareMeter() {
    super(UNIT_OF_MEASURE_GRAMS_PER_SQUARE_METER_ID, UNIT_OF_MEASURE_GRAMS_PER_SQUARE_METER_NAME);
  }

  public static UnitOfMeasureGramsPerSquareMeter getInstance() {
    return UnitOfMeasureGramsPerSquareMeter.InstanceHolder.INSTANCE;
  }
}
