/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for mass over distance.
 */
@Data
public final class UnitOfMeasureKilogramsPerKilometer extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureKilogramsPerKilometer INSTANCE = new UnitOfMeasureKilogramsPerKilometer();
  }

  public static final String UNIT_OF_MEASURE_KILOGRAMS_PER_KILOMETER_ID = "UnitOfMeasureKilogramsPerKilometerId";
  public static final String UNIT_OF_MEASURE_KILOGRAMS_PER_KILOMETER_NAME = "kg/km";

  private UnitOfMeasureKilogramsPerKilometer() {
    super(UNIT_OF_MEASURE_KILOGRAMS_PER_KILOMETER_ID, UNIT_OF_MEASURE_KILOGRAMS_PER_KILOMETER_NAME);
  }

  public static UnitOfMeasureKilogramsPerKilometer getInstance() {
    return UnitOfMeasureKilogramsPerKilometer.InstanceHolder.INSTANCE;
  }
}
