/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

@Data
public final class UnitOfMeasureKilometersPerKiloWattHour extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureKilometersPerKiloWattHour INSTANCE = new UnitOfMeasureKilometersPerKiloWattHour();
  }

  public static final String UNIT_OF_MEASURE_KILOMETERS_PER_KILO_WATT_HOUR_ID =
      "UnitOfMeasureKilometersPerKiloWattHourId";
  public static final String UNIT_OF_MEASURE_KILOMETERS_PER_KILO_WATT_HOUR_NAME = "km/kWh";

  private UnitOfMeasureKilometersPerKiloWattHour() {
    super(UNIT_OF_MEASURE_KILOMETERS_PER_KILO_WATT_HOUR_ID, UNIT_OF_MEASURE_KILOMETERS_PER_KILO_WATT_HOUR_NAME);
  }

  public static UnitOfMeasureKilometersPerKiloWattHour getInstance() {
    return UnitOfMeasureKilometersPerKiloWattHour.InstanceHolder.INSTANCE;
  }
}
