/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for volume over mass.
 */
@Data
public final class UnitOfMeasureLitersPerTonne extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureLitersPerTonne INSTANCE = new UnitOfMeasureLitersPerTonne();
  }

  public static final String UNIT_OF_MEASURE_LITERS_PER_TONNE_ID = "UnitOfMeasureLitersPerTonneId";
  public static final String UNIT_OF_MEASURE_LITERS_PER_TONNE_NAME = "L/tonne";

  private UnitOfMeasureLitersPerTonne() {
    super(UNIT_OF_MEASURE_LITERS_PER_TONNE_ID, UNIT_OF_MEASURE_LITERS_PER_TONNE_NAME);
  }

  public static UnitOfMeasureLitersPerTonne getInstance() {
    return UnitOfMeasureLitersPerTonne.InstanceHolder.INSTANCE;
  }
}
