/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for distance.
 */
@Data
public final class UnitOfMeasureMeters extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureMeters INSTANCE = new UnitOfMeasureMeters();
  }

  public static final String UNIT_OF_MEASURE_METERS_ID = "UnitOfMeasureMetersId";
  public static final String UNIT_OF_MEASURE_METERS_NAME = "m";

  private UnitOfMeasureMeters() {
    super(UNIT_OF_MEASURE_METERS_ID, UNIT_OF_MEASURE_METERS_NAME);
  }

  public static UnitOfMeasureMeters getInstance() {
    return UnitOfMeasureMeters.InstanceHolder.INSTANCE;
  }
}
