/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for force.
 */
@Data
public final class UnitOfMeasureNewtons extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureNewtons INSTANCE = new UnitOfMeasureNewtons();
  }

  public static final String UNIT_OF_MEASURE_NEWTONS_ID = "UnitOfMeasureNewtonsId";
  public static final String UNIT_OF_MEASURE_NEWTONS_NAME = "N";

  private UnitOfMeasureNewtons() {
    super(UNIT_OF_MEASURE_NEWTONS_ID, UNIT_OF_MEASURE_NEWTONS_NAME);
  }

  public static UnitOfMeasureNewtons getInstance() {
    return UnitOfMeasureNewtons.InstanceHolder.INSTANCE;
  }
}
