/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * The placeholder unit of measure for a diagnostic that does not have any specific unit.
 */
@Data
public final class UnitOfMeasureNone extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureNone INSTANCE = new UnitOfMeasureNone();
  }

  public static final String UNIT_OF_MEASURE_NONE_ID = "UnitOfMeasureNoneId";
  public static final String UNIT_OF_MEASURE_NONE_NAME = "None";

  private UnitOfMeasureNone() {
    super(UNIT_OF_MEASURE_NONE_ID, UNIT_OF_MEASURE_NONE_NAME);
  }

  public static UnitOfMeasureNone getInstance() {
    return UnitOfMeasureNone.InstanceHolder.INSTANCE;
  }
}
