/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for electrical resistance per second.
 */
@Data
public final class UnitOfMeasureOhmsPerSecond extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureOhmsPerSecond INSTANCE = new UnitOfMeasureOhmsPerSecond();
  }

  public static final String UNIT_OF_MEASURE_OHMS_PER_SECOND_ID = "UnitOfMeasureOhmsPerSecondId";
  public static final String UNIT_OF_MEASURE_OHMS_PER_SECOND_NAME = "Ohm/s";

  private UnitOfMeasureOhmsPerSecond() {
    super(UNIT_OF_MEASURE_OHMS_PER_SECOND_ID, UNIT_OF_MEASURE_OHMS_PER_SECOND_NAME);
  }

  public static UnitOfMeasureOhmsPerSecond getInstance() {
    return UnitOfMeasureOhmsPerSecond.InstanceHolder.INSTANCE;
  }
}
