/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for pressure.
 */
@Data
public final class UnitOfMeasurePascals extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasurePascals INSTANCE = new UnitOfMeasurePascals();
  }

  public static final String UNIT_OF_MEASURE_PASCALS_ID = "UnitOfMeasurePascalsId";
  public static final String UNIT_OF_MEASURE_PASCALS_NAME = "Pa";

  private UnitOfMeasurePascals() {
    super(UNIT_OF_MEASURE_PASCALS_ID, UNIT_OF_MEASURE_PASCALS_NAME);
  }

  public static UnitOfMeasurePascals getInstance() {
    return UnitOfMeasurePascals.InstanceHolder.INSTANCE;
  }
}
