/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure an amount of digital pulses per meter.
 */
@Data
public final class UnitOfMeasurePulsesPerMeter extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasurePulsesPerMeter INSTANCE = new UnitOfMeasurePulsesPerMeter();
  }

  public static final String UNIT_OF_MEASURE_PULSES_PER_METER_ID = "UnitOfMeasurePulsesPerMeterId";
  public static final String UNIT_OF_MEASURE_PULSES_PER_METER_NAME = "pulses/m";

  private UnitOfMeasurePulsesPerMeter() {
    super(UNIT_OF_MEASURE_PULSES_PER_METER_ID, UNIT_OF_MEASURE_PULSES_PER_METER_NAME);
  }

  public static UnitOfMeasurePulsesPerMeter getInstance() {
    return UnitOfMeasurePulsesPerMeter.InstanceHolder.INSTANCE;
  }
}
