/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure an amount of circulation rotations.
 */
@Data
public final class UnitOfMeasureRevolutions extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureRevolutions INSTANCE = new UnitOfMeasureRevolutions();
  }

  public static final String UNIT_OF_MEASURE_REVOLUTIONS_ID = "UnitOfMeasureRevolutionsId";
  public static final String UNIT_OF_MEASURE_REVOLUTIONS_NAME = "rev";

  private UnitOfMeasureRevolutions() {
    super(UNIT_OF_MEASURE_REVOLUTIONS_ID, UNIT_OF_MEASURE_REVOLUTIONS_NAME);
  }

  public static UnitOfMeasureRevolutions getInstance() {
    return UnitOfMeasureRevolutions.InstanceHolder.INSTANCE;
  }
}
