/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for electrical potential.
 */
@Data
public final class UnitOfMeasureVolts extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureVolts INSTANCE = new UnitOfMeasureVolts();
  }

  public static final String UNIT_OF_MEASURE_VOLTS_ID = "UnitOfMeasureVoltsId";
  public static final String UNIT_OF_MEASURE_VOLTS_NAME = "V";

  private UnitOfMeasureVolts() {
    super(UNIT_OF_MEASURE_VOLTS_ID, UNIT_OF_MEASURE_VOLTS_NAME);
  }

  public static UnitOfMeasureVolts getInstance() {
    return UnitOfMeasureVolts.InstanceHolder.INSTANCE;
  }
}
