/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.unitofmeasure;

import lombok.Data;

/**
 * Represents the unit of measure for electrical power.
 */
@Data
public final class UnitOfMeasureWatts extends UnitOfMeasureSystem {

  private static class InstanceHolder {

    private static final UnitOfMeasureWatts INSTANCE = new UnitOfMeasureWatts();
  }

  public static final String UNIT_OF_MEASURE_WATTS_ID = "UnitOfMeasureWattsId";
  public static final String UNIT_OF_MEASURE_WATTS_NAME = "W";

  private UnitOfMeasureWatts() {
    super(UNIT_OF_MEASURE_WATTS_ID, UNIT_OF_MEASURE_WATTS_NAME);
  }

  public static UnitOfMeasureWatts getInstance() {
    return UnitOfMeasureWatts.InstanceHolder.INSTANCE;
  }
}
