/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.user;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum DriverKeyType implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown", -1),

  /**
   * USB blue driver ID Key.
   */
  USB("Usb", 0),

  /**
   * NFC driver ID Key.
   */
  NFC("Nfc", 1),

  /**
   * CustomNfc driver ID Key.
   */
  CUSTOM_NFC("CustomNfc", 2),

  /**
   * Tachograph driver ID Key.
   */
  TACHOGRAPH("Tachograph", 3),

  /**
   * Custom driver ID Key.
   */
  CUSTOM("Custom", 4);

  private final String name;
  private final int code;

  DriverKeyType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
