/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.user;

import com.geotab.model.entity.Entity;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Represent the key used to identify a {@link Driver}.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class Key extends Entity {

  /**
   * The driver key type.
   */
  private DriverKeyType driverKeyType;

  /**
   * The ID of the driver key. Represents the decoded serial number. USB blue keys are assigned a key ID.
   */
  private Long keyId;

  /**
   * The Serial Number of the driver key. Represents the key ID encoded as a serial number. NFC keys are assigned a
   * serial number.
   */
  private String serialNumber;
}
