/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.user;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * A driver object that represents no driver.
 */
@Data
public final class NoDriver extends Driver implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final NoDriver INSTANCE = new NoDriver();
  }

  public static final String NO_DRIVER_ID = "NoDriverId";

  private NoDriver() {
    setId(new Id(NO_DRIVER_ID));
    setName("**NoDriver");
    setVersion(0L);
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }

  public static NoDriver getInstance() {
    return InstanceHolder.INSTANCE;
  }
}
