/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.user;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * The internal user that has access to everything and is used internally by MyGeotab processes.
 */
@Data
public final class SystemUser extends User implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final SystemUser INSTANCE = new SystemUser();
  }

  public static final String SYSTEM_USER_ID = "SystemUserId";

  private SystemUser() {
    setId(new Id(SYSTEM_USER_ID));
    setName("System");
    setVersion(0L);
  }

  public static SystemUser getInstance() {
    return InstanceHolder.INSTANCE;
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }
}
