package com.geotab.model.entity.user;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;
import com.geotab.util.Util;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public enum UserAuthenticationType implements HasName {

  /**
   * None or unknown.
   */
  @JsonEnumDefaultValue
  NONE("None", 0),

  /**
   * Authentication using passwords.
   */
  BASIC_AUTHENTICATION("BasicAuthentication", 1),

  /**
   * Authentication using Windows Domains.
   */
  WINDOWS_AUTHENTICATION("WindowsAuthentication", 2),

  /**
   * MyAdmin global user.
   */
  MY_ADMIN("MyAdmin", 4),

  /**
   * Authentication using SAML.
   */
  SAML("SAML", 8),

  /**
   * Authentication using Certificate.
   */
  CLIENT_CERTIFICATE("ClientCertificate", 16);

  private final String name;
  private final int code;

  UserAuthenticationType(String name, int code) {
    this.name = name;
    this.code = code;
  }

  public int getCode() {
    return code;
  }

  @JsonValue
  public String getName() {
    return name;
  }

  public static UserAuthenticationType findOrDefault(String name) {
    if (Util.isEmpty(name)) {
      log.warn("Empty value is not recognized for {} enum; returning default {}",
          UserAuthenticationType.class.getSimpleName(), UserAuthenticationType.NONE);
      return NONE;
    }

    for (UserAuthenticationType authenticationType : values()) {
      if (authenticationType.getName().equalsIgnoreCase(name.trim())) {
        return authenticationType;
      }
    }

    log.warn("{} is not recognized for {} enum; returning default {}",
        name, UserAuthenticationType.class.getSimpleName(), UserAuthenticationType.NONE);
    return NONE;
  }
}
