package com.geotab.model.entity.worktime;

import com.geotab.model.entity.Entity;
import java.time.Duration;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The times during the week that are working times.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class WorkTimeDetail extends Entity {

  public static final int MAX_VALUE = 86399999;

  public static final int MIN_VALUE = 0;

  /**
   * Day of the week; with Sunday being 0, Monday being 1, etc..
   */
  private DayOfWeek dayOfWeek;

  /**
   * The timeSpan since the start of the period.
   */
  private Duration fromTime;

  /**
   * The timeSpan to the end of the period.
   */
  private Duration toTime;
}
