/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.zone;

import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonValue;
import com.geotab.model.serialization.HasName;

public enum IncludeGroups implements HasName {

  /**
   * Fallback when enumeration value is unknown.
   */
  @JsonEnumDefaultValue
  UNKNOWN("Unknown"),

  /**
   * Include Children groups in the query results.
   */
  CHILD("Child"),

  /**
   * Include Parent groups in the query results.
   */
  PARENT("Parent"),

  /**
   * Include Parent and Children groups in the query results.
   */
  PARENT_AND_CHILD("ParentAndChild"),

  /**
   * Directly related groups only in the query results.
   */
  DIRECT("Direct");

  private final String name;

  IncludeGroups(String name) {
    this.name = name;
  }

  @JsonValue
  public String getName() {
    return name;
  }
}
