/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.zone;

import com.geotab.model.Id;
import com.geotab.model.serialization.SystemEntitySerializationAware;
import lombok.Data;

/**
 * A zone that is unassigned.
 */
@Data
public class NoZone extends Zone implements SystemEntitySerializationAware {

  private static class InstanceHolder {

    private static final NoZone INSTANCE = new NoZone();
  }

  public static final String NO_ZONE_ID = "NoZoneId";

  private NoZone() {
    setId(new Id(NO_ZONE_ID));
    setName("***Unassigned Zone");
    setVersion(0L);
  }

  @Override
  public boolean isSystemEntity() {
    return true;
  }

  public static NoZone getInstance() {
    return NoZone.InstanceHolder.INSTANCE;
  }
}
