/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.zone.type;

import static com.geotab.model.entity.zone.type.ZoneTypeAddressLookup.ZONE_TYPE_ADDRESS_LOOKUP_ID;
import static com.geotab.model.entity.zone.type.ZoneTypeCustomer.ZONE_TYPE_CUSTOMER_ID;
import static com.geotab.model.entity.zone.type.ZoneTypeHome.ZONE_TYPE_HOME_ID;
import static com.geotab.model.entity.zone.type.ZoneTypeOffice.ZONE_TYPE_OFFICE_ID;

import com.geotab.model.Id;
import com.geotab.model.entity.NameEntity;
import com.geotab.util.Util;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * The type of the zone.
 */
@Data
@NoArgsConstructor
@SuperBuilder
public class ZoneType extends NameEntity {

  /**
   * A free text field where any user information can be stored and referenced for this entity. Default [""].
   */
  private String comment;

  public ZoneType(String id) {
    setId(new Id(id));
    setName(id);
  }

  public static ZoneType fromSystem(String id) {
    if (Util.isEmpty(id)) return null;
    switch (id) {
      case ZONE_TYPE_HOME_ID:
        return ZoneTypeHome.getInstance();
      case ZONE_TYPE_ADDRESS_LOOKUP_ID:
        return ZoneTypeAddressLookup.getInstance();
      case ZONE_TYPE_OFFICE_ID:
        return ZoneTypeOffice.getInstance();
      case ZONE_TYPE_CUSTOMER_ID:
        return ZoneTypeCustomer.getInstance();
      default:
        return null;
    }
  }
}
