/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.zone.type;

import com.geotab.model.Id;
import lombok.Data;

/**
 * A zone type that is a customer.
 */
@Data
public class ZoneTypeCustomer extends ZoneTypeSystem {

  private static class InstanceHolder {

    private static final ZoneTypeCustomer INSTANCE = new ZoneTypeCustomer();
  }

  public static final String ZONE_TYPE_CUSTOMER_ID = "ZoneTypeCustomerId";

  public ZoneTypeCustomer() {
    setId(new Id(ZONE_TYPE_CUSTOMER_ID));
    setName("**Customer Zone");
    setComment("");
  }

  public static ZoneTypeCustomer getInstance() {
    return ZoneTypeCustomer.InstanceHolder.INSTANCE;
  }
}
