/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.entity.zone.type;

import com.geotab.model.Id;
import lombok.Data;

/**
 * Zone Type that is an office zone.
 */
@Data
public class ZoneTypeOffice extends ZoneTypeSystem {

  private static class InstanceHolder {

    private static final ZoneTypeOffice INSTANCE = new ZoneTypeOffice();
  }

  public static final String ZONE_TYPE_OFFICE_ID = "ZoneTypeOfficeId";

  public ZoneTypeOffice() {
    setId(new Id(ZONE_TYPE_OFFICE_ID));
    setName("**Office Zone");
    setComment("");
  }

  public static ZoneTypeOffice getInstance() {
    return ZoneTypeOffice.InstanceHolder.INSTANCE;
  }
}
