/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.dutystatus.AnnotationLog;
import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link AnnotationLog}(s).
 */
@Data
@NoArgsConstructor
public class AnnotationLogSearch extends IdSearch {

  /**
   * The AnnotationLog logs are searched for events which were recorded on or after this date.
   */
  private LocalDateTime fromDate;

  /**
   * The Fault data logs are searched for events which were recorded on or before this date.
   */
  private LocalDateTime toDate;

  /**
   * Search for {@link AnnotationLog} with this UserSearch Id
   *
   * <p>Available UserSearch options are:.
   * <ul>
   *    <li>Id</li>
   * </ul>
   */
  private UserSearch userSearch;

  /**
   * Search for AnnotationLogs which have a comment that contains this string. Wildcard can be used by
   * prepending/appending "%" to string.
   */
  private String comment;

  @Builder
  public AnnotationLogSearch(String id, LocalDateTime fromDate, LocalDateTime toDate,
      UserSearch userSearch, String comment) {
    super(id);
    this.fromDate = fromDate;
    this.toDate = toDate;
    this.userSearch = userSearch;
    this.comment = comment;
  }
}
