/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.audit.Audit;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link Audit}(s).
 */
@Data
@NoArgsConstructor
public class AuditSearch extends IdSearch {

  /**
   * Search for audit entries that were recorded at this date or after.
   */
  private LocalDateTime fromDate;

  /**
   * Search for audit entries that were recorded before this date.
   */
  private LocalDateTime toDate;

  /**
   * Search for audit entries with this User Name. Wildcard can be used by prepending/appending "%" to string. Example
   * "%name%"
   */
  private String userName;

  /**
   * Search for audit entries with this Name. Wildcard can be used by prepending/appending "%" to string. Example
   * "%name%".
   */
  private String name;

  /**
   * Search for entities that contain specific keywords in all wildcard string-searchable fields.
   */
  private List<String> keywords;

  @Builder
  public AuditSearch(String id, LocalDateTime fromDate, LocalDateTime toDate,
      String userName, String name, List<String> keywords) {
    super(id);
    this.fromDate = fromDate;
    this.toDate = toDate;
    this.userName = userName;
    this.name = name;
    this.keywords = keywords;
  }
}
