/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for a {@link com.geotab.model.entity.controller.Controller}.
 */
@Data
@NoArgsConstructor
public class ControllerSearch extends IdSearch {

  /**
   * Search for Controllers with this Name. Wildcard can be used by prepending/appending "%" to string. Example
   * "%name%".
   */
  private String name;

  /**
   * Search for {@link com.geotab.model.entity.controller.Controller}s with this {@link
   * com.geotab.model.entity.source.Source} Id.
   */
  private IdSearch sourceSearch;

  @Builder
  public ControllerSearch(String id, String name, IdSearch sourceSearch) {
    super(id);
    this.name = name;
    this.sourceSearch = sourceSearch;
  }
}
