/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import java.util.List;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The search criteria for entities that support custom properties.
 */
@Data
@NoArgsConstructor
public class CustomPropertySearch extends IdSearch {

  /**
   * Search for Properties with this Value. Wildcard can be used by prepending/appending "%" to string. Example
   * "%Value%".
   */
  private String value;

  /**
   * Search for Entities that are a member of these {@link PropertySetSearch}(s). Each PropertySetSearch is an object
   * within the array.
   *
   * <p>Available PropertySetSearch options are:
   * <ul>
   *    <li>id</li>
   * </ul>
   * <ul>
   *    <li>groups</li>
   * </ul>
   */
  private List<PropertySetSearch> propertySetSearches;

  /**
   * Search for Entities that are a member of these {@link PropertySearch}(s). Each PropertySearch is an object within
   * the array.
   *
   * <p>Available PropertySearch options are:
   * <ul>
   *    <li>id</li>
   * </ul>
   */
  private List<PropertySearch> propertySearches;

  @Builder
  public CustomPropertySearch(String id, String value,
      List<PropertySetSearch> propertySetSearches,
      List<PropertySearch> propertySearches) {
    super(id);
    this.value = value;
    this.propertySetSearches = propertySetSearches;
    this.propertySearches = propertySearches;
  }
}
