/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.coordinate.Coordinate;
import com.geotab.model.entity.device.Device;
import com.geotab.model.entity.devicestatusinfo.DeviceStatusInfo;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Used to specify the arguments when searching for {@link DeviceStatusInfo}(s).
 */
@Data
@NoArgsConstructor
public class DeviceStatusInfoSearch implements Search {

  /**
   * The maximum number of {@link Device}s to search for when specifying a "Position".
   */
  private Integer closestAssetLimit;

  /**
   * Search for {@link DeviceStatusInfo}(s) from a device that matches the {@link DeviceSearch} Id or in the Groups
   * specified. This includes archived and deleted devices.
   *
   * <p>Available {@link DeviceSearch} options are:.
   * <ul>
   *    <li>id</li>
   *    <li>groups</li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  /**
   * Search for Status Info for {@link Device}s in the vicinity of the provided {@link Coordinate}. Starting from this
   * position, an outward search for Devices will continue until the number of devices found matches the number defined
   * in the "ClosestAssetLimit" property.
   */
  private Coordinate position;

  /**
   * Search for Device Status Info associated with this {@link UserSearch} Id.
   *
   * <p>Available {@link UserSearch} options are:.
   * <ul>
   *    <li>id</li>
   * </ul>
   */
  private UserSearch userSearch;

  @Builder
  public DeviceStatusInfoSearch(Integer closestAssetLimit,
      DeviceSearch deviceSearch, Coordinate position, UserSearch userSearch) {
    this.closestAssetLimit = closestAssetLimit;
    this.deviceSearch = deviceSearch;
    this.position = position;
    this.userSearch = userSearch;
  }
}
