/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.Id;
import com.geotab.model.entity.distributionlist.DistributionList;
import com.geotab.model.entity.recipient.Recipient;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Used to specify the arguments when searching for {@link DistributionList}s.
 */
@Data
@NoArgsConstructor
public class DistributionListSearch extends IdSearch {

  /**
   * The maximum Id of the search criteria.
   */
  private Id maxId;

  /**
   * Search for DistributionLists with these full {@link Recipient} objects.
   *
   * <p>Available {@link RecipientSearch} options are:
   *  <ul>
   *     <li>
   *         {@link Id}
   *     </li>
   * </ul>
   */
  private RecipientSearch recipientSearch;

  /**
   * Search for DistributionLists with this {@link RuleSearch} id.
   *
   * <p>Available {@link RuleSearch} options are:
   *  <ul>
   *     <li>
   *         {@link Id}
   *     </li>
   * </ul>
   */
  private RuleSearch ruleSearch;

  @Builder
  public DistributionListSearch(String id, Id maxId,
      RecipientSearch recipientSearch, RuleSearch ruleSearch) {
    super(id);
    this.maxId = maxId;
    this.recipientSearch = recipientSearch;
    this.ruleSearch = ruleSearch;
  }
}
