/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.dutystatus.DutyStatusViolation;
import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link DutyStatusViolation}(s).
 */
@Data
@NoArgsConstructor
public class DutyStatusViolationSearch implements Search {

  /**
   * Search for duty status violations that were recorded at this date or after.
   */
  private LocalDateTime fromDate;

  /**
   * Search for duty status violations that were recorded at this date or before.
   */
  private LocalDateTime toDate;

  /**
   * Search for duty status violations with this {@link UserSearch}.
   *
   * <p>Available UserSearch options are:.
   * <ul>
   *    <li>Id</li>
   *    <li>CompanyGroups</li>
   *    <li>DriverGroups</li>
   * </ul>
   */
  private UserSearch userSearch;

  @Builder
  public DutyStatusViolationSearch(LocalDateTime fromDate, LocalDateTime toDate,
      UserSearch userSearch) {
    this.fromDate = fromDate;
    this.toDate = toDate;
    this.userSearch = userSearch;
  }
}
