/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.ioxaddon.IoxAddOn;
import com.geotab.model.entity.ioxaddon.KnownIoxAddOnType;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link IoxAddOn}(s).
 */
@Data
@NoArgsConstructor
public class IoxAddOnSearch extends IdSearch {

  /**
   * Search for {@link IoxAddOn} with this DeviceSearch Id.
   *
   * <p>Available DeviceSearch options are:
   * <ul>
   *    <li>id</li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  /**
   * Search for Iox Add-Ons of a specific type (Garmin, GoTalk etc). See {@link KnownIoxAddOnType}.
   */
  private Integer type;

  /**
   * If <c>true</c> only Iox Add-Ons that are currently connected to a device will be returned.
   */
  private Boolean connectedOnly;

  @Builder
  public IoxAddOnSearch(String id, DeviceSearch deviceSearch, Integer type,
      Boolean connectedOnly) {
    super(id);
    this.deviceSearch = deviceSearch;
    this.type = type;
    this.connectedOnly = connectedOnly;
  }
}
