/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.recipient.Recipient;
import com.geotab.model.entity.recipient.RecipientType;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link Recipient}(s).
 */
@Data
@NoArgsConstructor
public class RecipientSearch extends IdSearch {

  /**
   * Search for {@link Recipient}s of this {@link RecipientType}.
   */
  private RecipientType recipientType;

  @Builder
  public RecipientSearch(String id, RecipientType recipientType) {
    super(id);
    this.recipientType = recipientType;
  }
}
