/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.shipmentlog.ShipmentLog;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link ShipmentLog}(s).
 */
@Data
@NoArgsConstructor
public class ShipmentLogSearch implements Search {

  /**
   * Search for ShipmentLogs with this commodity. Wildcard can be used by prepending/appending "%" to string.
   */
  private String commodity;

  /**
   * Search for ShipmentLogs with this document number. Wildcard can be used by prepending/appending "%" to string.
   */
  private String documentNumber;

  /**
   * The search options which are used to search for shipment log for a device by id.
   *
   * <p>Available DeviceSearch options are:.
   * <ul>
   *    <li>Id</li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  /**
   * Search for ShipmentLogs that were active at this date or after. Set to UTC now to search for only currently active
   * ShipmentLogs.
   */
  private LocalDateTime fromDate;

  /**
   * Search for ShipmentLogs that were active at this date or before. Set to UTC now to search for only currently active
   * ShipmentLogs.
   */
  private LocalDateTime toDate;

  /**
   * Search for ShipmentLogs with this shipper name. Wildcard can be used by prepending/appending "%" to string.
   */
  private String shipperName;

  /**
   * Search for {@link ShipmentLog} with this UserSearch Id
   *
   * <p>Available UserSearch options are:.
   * <ul>
   *    <li>Id</li>
   * </ul>
   */
  private UserSearch userSearch;

  /**
   * Search for entities that contain specific keywords in all wildcard string-searchable fields.
   */
  private List<String> keywords;


  @Builder
  public ShipmentLogSearch(String commodity, String documentNumber,
      DeviceSearch deviceSearch, LocalDateTime fromDate, LocalDateTime toDate,
      String shipperName, UserSearch userSearch, List<String> keywords) {
    this.commodity = commodity;
    this.documentNumber = documentNumber;
    this.deviceSearch = deviceSearch;
    this.fromDate = fromDate;
    this.toDate = toDate;
    this.shipperName = shipperName;
    this.userSearch = userSearch;
    this.keywords = keywords;
  }
}
