/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.search;

import com.geotab.model.entity.trailer.TrailerAttachment;
import java.time.LocalDateTime;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * The object used to specify the arguments when searching for {@link TrailerAttachment}(s).
 */
@Data
@NoArgsConstructor
public class TrailerAttachmentSearch extends IdSearch {

  /**
   * Search for TrailerAttachments with this TrailerSearch Id.
   *
   * <p>Available TrailerSearch options are:
   * <ul>
   *      <li>
   *            Id
   *     </li>
   * </ul>
   */
  private TrailerSearch trailerSearch;

  /**
   * Search for TrailerAttachments attached to this DeviceSearch  Id.
   *
   * <p>Available DeviceSearch options are:
   * <ul>
   *      <li>
   *            Id
   *     </li>
   * </ul>
   */
  private DeviceSearch deviceSearch;

  /**
   * Search for TrailerAttachments that were active at this date or after. Set to UTC now to search for only currently
   * active TrailerAttachments.
   */
  private LocalDateTime activeFrom;

  /**
   * Search for TrailerAttachments that were active at this date or before.
   */
  private LocalDateTime activeTo;

  @Builder
  public TrailerAttachmentSearch(String id, TrailerSearch trailerSearch,
      DeviceSearch deviceSearch, LocalDateTime activeFrom, LocalDateTime activeTo) {
    super(id);
    this.trailerSearch = trailerSearch;
    this.deviceSearch = deviceSearch;
    this.activeFrom = activeFrom;
    this.activeTo = activeTo;
  }
}
