/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;

public class ApiCustomDeserializerModifier extends BeanDeserializerModifier {

  @Override
  public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config,
      BeanDescription beanDesc, JsonDeserializer<?> deserializer) {

    // add custom deserializers if necessary

    return deserializer;
  }

  /**
   * It will recreate {@link JsonParser} based on the {@link JsonNode}, as the stream was closed if the {@link JsonNode}
   * was read initially by parserCodec.readTree(jsonParser). Otherwise the stream is empty and exception occurs.
   */
  public static <T> T defaultDeserialize(ObjectCodec parserCodec,
      DeserializationContext context, JsonNode node, Class<T> userType)
      throws IOException {
    DeserializationConfig config = context.getConfig();

    JavaType type = TypeFactory.defaultInstance().constructType(userType);
    JsonDeserializer<Object> defaultDeserializer = BeanDeserializerFactory.instance
        .buildBeanDeserializer(context, type, config.introspect(type));

    if (defaultDeserializer instanceof ResolvableDeserializer) {
      ((ResolvableDeserializer) defaultDeserializer).resolve(context);
    }

    JsonParser treeParser = parserCodec.treeAsTokens(node);
    config.initialize(treeParser);

    if (treeParser.getCurrentToken() == null) {
      treeParser.nextToken();
    }

    return (T) defaultDeserializer.deserialize(treeParser, context);
  }
}
