/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.util.Util;
import java.io.IOException;
import java.util.Base64;

public class ByteArrayDeserializer extends JsonDeserializer<Byte[]> {

  @Override
  public Byte[] deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
    ObjectCodec parserCodec = jsonParser.getCodec();
    JsonNode node = parserCodec.readTree(jsonParser);

    if (node.isTextual()) {
      String binaryData = node.textValue();
      if (Util.isNotEmpty(binaryData)) {
        byte[] array = getBinaryDataBytes(binaryData);
        final Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; i++) {
          result[i] = array[i];
        }
        return result;
      }
    }

    return new Byte[0];
  }

  private byte[] getBinaryDataBytes(String binaryData) {
    try {
      return Base64.getDecoder().decode(binaryData.getBytes());
    } catch (IllegalArgumentException exception) { // not base64 encoded
      return binaryData.getBytes();
    }
  }
}
