/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.coordinate.Coordinate;
import com.geotab.model.coordinate.TemporalCoordinate;
import com.geotab.util.DateTimeUtil;
import java.io.IOException;
import java.time.LocalDateTime;

public class CoordinateDeserializer extends JsonDeserializer<Coordinate> {

  @Override
  public Coordinate deserialize(JsonParser jsonParser, DeserializationContext context)
      throws IOException {
    ObjectCodec parserCodec = jsonParser.getCodec();
    JsonNode node = parserCodec.readTree(jsonParser);

    if (node.isObject()) {
      double x = node.get("x") != null ? node.get("x").doubleValue() : 0d;
      double y = node.get("y") != null ? node.get("y").doubleValue() : 0d;
      LocalDateTime dateTime = node.get("dateTime") != null ? DateTimeUtil
          .localDateTimeFromString(node.get("dateTime").textValue()) : null;

      if (dateTime != null) {
        return new TemporalCoordinate(x, y, dateTime);
      }
      return new Coordinate(x, y);
    }

    return null;
  }
}
