/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import static com.geotab.util.Util.listOf;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.geotab.model.entity.group.Defect;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class DefectListDeserializer extends JsonDeserializer<List<Defect>> {

  @Override
  public List<Defect> deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
    ObjectCodec oc = jsonParser.getCodec();
    JsonNode node = oc.readTree(jsonParser);
    Iterator<JsonNode> elements = node.elements();
    List<Defect> defects = listOf();
    while (elements.hasNext()) {
      defects.add(DefectDeserializer.deserializeWithChildren(elements.next()));
    }
    return defects;
  }
}
