/*
 *
 * 2020 Copyright (C) Geotab Inc. All rights reserved.
 */

package com.geotab.model.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class DoublePrimitiveArraySerializer extends JsonSerializer<double[]> {

  @Override
  public void serialize(double[] doubleArray, JsonGenerator jsonGenerator,
      SerializerProvider serializers) throws IOException {

    jsonGenerator.writeStartArray();

    for (double number : doubleArray) {
      ApiJsonSerializer.serializeNumberWithDecimals(number, jsonGenerator);
    }

    jsonGenerator.writeEndArray();
  }
}
